<#import "template.ftl" as layout>
<@layout.registrationLayout displayInfo=social.displayInfo displayWide=(realm.password && social.providers??); section>
    <#if section = "header">
        ${msg("doLogIn")}
    <#elseif section = "form">
        <#if realm.password>
        <form onsubmit="login.disabled = true; return true;" action="${url.loginAction}" method="post" class="ui form">
            <div class="field required">
                <label for="usernameOrEmail"><#if !realm.loginWithEmailAllowed>${msg("username")}<#elseif !realm.registrationEmailAsUsername>${msg("usernameOrEmail")}<#else>${msg("email")}</#if></label>
                <#if usernameEditDisabled??>
                    <input type="text"
                           name="username"
                           id="username"
                           tabindex="1"
                           class="kc-input-field"
                           value="${(login.username!'')}"
                           disabled>
                <#else>
                    <input type="text"
                           name="username"
                           id="username"
                           autocomplete="off"
                           class="kc-input-field"
                           tabindex="1"
                           value="${(login.username!'')}"
                           autofocus>
                </#if>
            </div>
            <div class="field required">
                <label for="password">${msg("password")}</label>
                <input type="password"
                       name="password"
                       autocomplete="off"
                       class="kc-input-field"
                       id="password"
                       tabindex="2">
            </div>
            <div class="two fields">
                <#if realm.rememberMe && !usernameEditDisabled??>
                    <div class="field">
                        <div class="ui checkbox">
                            <#if login.rememberMe??>
                                <input type="checkbox"
                                       name="rememberMe"
                                       id="rememberMe"
                                       tabindex="3"
                                       checked>
                            <#else>
                                <input type="checkbox"
                                       name="rememberMe"
                                       id="rememberMe"
                                       tabindex="3">
                            </#if>
                            <label for="stayLoggedInCheckbox">${msg("rememberMe")}</label>
                        </div>
                    </div>
                </#if>
                <div class="field kc-field-forgot-password" style="text-align: right;">
                    <#if realm.resetPasswordAllowed>
                        <div class="ui text">
                            <a href="${url.loginResetCredentialsUrl}" tabindex="5">${msg("doForgotPassword")}</a>
                        </div>
                    </#if>
                </div>
            </div>
            <div class="field">
                <button class="fluid ui button pink"
                        type="submit"
                        name="login"
                        tabindex="4">
                    ${msg("doLogIn")}
                </button>
            </div>
        </form>
        </#if>
    <#elseif section = "info" >
        <#if realm.password && realm.registrationAllowed && !usernameEditDisabled??>
            <div class="ui centered grid kc-field-new-user">
                ${msg("noAccount")} <a href="${url.registrationUrl}">${msg("doRegister")}</a>
            </div>
        </#if>
    </#if>
</@layout.registrationLayout>
