<#import "template.ftl" as layout>
<@layout.registrationLayout displayInfo=true; section>
    <#if section = "header">
        ${msg("emailForgotTitle")}
    <#elseif section = "form">
        <form action="${url.loginAction}" method="post" class="ui form">
            <div class="field required">
                <label for="username">
                    <#if !realm.loginWithEmailAllowed>
                        ${msg("username")}
                    <#elseif !realm.registrationEmailAsUsername>
                        ${msg("usernameOrEmail")}
                    <#else>
                        ${msg("email")}
                    </#if>
                </label>
                <input type="text"
                       name="username"
                       id="username"
                       autocomplete="off"
                       class="kc-input-field"
                       tabindex="1"
                       autofocus>
            </div>
            <div class="field left aligned">
                <div class="ui text">
                    <a href="${url.loginUrl}" tabindex="3">${kcSanitize(msg("backToLogin"))?no_esc}</a>
                </div>
            </div>
            <div class="field">
                <button class="fluid ui button pink"
                        type="submit"
                        name="loginButton"
                        tabindex="2">
                    ${msg("doSubmit")}
                </button>
            </div>
        </form>
    <#elseif section = "info" >
        ${msg("emailInstruction")}
    </#if>
</@layout.registrationLayout>
