<#import "template.ftl" as layout>
<@layout.registrationLayout; section>
    <#if section = "header">
        ${msg("doRegister")}
    <#elseif section = "form">
        <form action="${url.registrationAction}" method="post" class="ui form">
            <div class="field required">
                <label for="firstName">${msg("firstName")}</label>
                <input type="text"
                       name="firstName"
                       id="firstName"
                       autocomplete="off"
                       tabindex="1"
                       class="kc-input-field"
                       value="${(register.formData.firstName!'')}"
                       autofocus>
            </div>
            <div class="field required">
                <label for="lastName">${msg("lastName")}</label>
                <input type="text"
                       name="lastName"
                       id="lastName"
                       class="kc-input-field"
                       autocomplete="off"
                       value="${(register.formData.lastName!'')}"
                       tabindex="2">
            </div>
            <div class="field required">
                <label for="email">${msg("email")}</label>
                <input type="text"
                       name="email"
                       id="email"
                       class="kc-input-field"
                       autocomplete="email"
                       value="${(register.formData.email!'')}"
                       tabindex="3">
            </div>

            <#if !realm.registrationEmailAsUsername>
                <div class="field required">
                    <label for="username">${msg("username")}</label>
                    <input type="text"
                           name="username"
                           id="username"
                           class="kc-input-field"
                           autocomplete="username"
                           value="${(register.formData.username!'')}"
                           tabindex="3">
                </div>
            </#if>
            <#if passwordRequired>
                <div class="field required">
                    <label for="password">${msg("password")}</label>
                    <input type="password"
                           name="password"
                           id="password"
                           class="kc-input-field"
                           autocomplete="new-password"
                           tabindex="4">
                </div>
                <div class="field required">
                    <label for="confirmPassword">${msg("passwordConfirm")}</label>
                    <input type="password"
                           name="password-confirm"
                           id="password-confirm"
                           class="kc-input-field"
                           autocomplete="password-confirm"
                           tabindex="5">
                </div>
            </#if>

            <#if recaptchaRequired??>
                <div class="form-group">
                    <div class="${properties.kcInputWrapperClass!}">
                        <div class="g-recaptcha" data-size="compact" data-sitekey="${recaptchaSiteKey}"></div>
                    </div>
                </div>
            </#if>

            <div class="two fields">
                <div class="field kc-field-forgotten-password">
                    <div class="ui text">
                        <a href="${url.loginUrl}" tabindex="7">${kcSanitize(msg("backToLogin"))?no_esc}</a>
                    </div>
                </div>
            </div>
            <button class="fluid ui button pink"
                    type="submit"
                    tabindex="6">
                ${msg("doRegister")}
            </button>
        </form>
    </#if>
</@layout.registrationLayout>
